/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.store.StoreDataAccessor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

class IOStoreDataAccessor
implements StoreDataAccessor {
    private Object lock = new Object();
    private File file;
    private RandomAccessFile data;
    private long size;
    private boolean is_open;

    IOStoreDataAccessor(File file) {
        this.file = file;
        this.is_open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean is_read_only) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.data = new RandomAccessFile(this.file, is_read_only ? "r" : "rw");
            this.size = this.file.length();
            this.is_open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.data.close();
            this.data = null;
            this.is_open = false;
        }
    }

    public boolean delete() {
        if (!this.is_open) {
            return this.file.delete();
        }
        return false;
    }

    public boolean exists() {
        return this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long position, byte[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            len = Math.max(0, Math.min(len, (int)(this.size - position)));
            if (position < this.size) {
                this.data.seek(position);
                this.data.readFully(buf, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long position, byte[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            len = Math.max(0, Math.min(len, (int)(this.size - position)));
            if (position < this.size) {
                this.data.seek(position);
                this.data.write(buf, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(long new_size) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (new_size > this.size) {
                long p = new_size - 1L;
                if (p > 0L) {
                    this.data.seek(p);
                    this.data.write(0);
                    this.size = new_size;
                }
            } else if (new_size < this.size) {
                this.data.setLength(new_size);
                this.size = new_size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.is_open) {
                return this.size;
            }
            return this.file.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.data.getFD().sync();
            }
            catch (SyncFailedException syncFailedException) {
                // empty catch block
            }
        }
    }
}

